--- Activates the client and their modules
-- @author QueuedResonance 2022

local Client = {
	AnimationUtils = require("ZomboWin/ZomboWinAnimationUtils"),
	Commands = require("ZomboWin/ZomboWinCommands"),
	Callbacks = require("ZomboWin/ZomboWinCallbacks"),
	ContextMenu = require("ZomboWin/ZomboWinContextMenu"),
	AnimationHandler = require("ZomboWin/ZomboWinAnimationHandler"),
	ZombieHandler = require("ZomboWin/ZomboWinZombieHandler"),
}

local function Init()
	--- Injects the Client data to all modules so they too can access the other modules without going through global
	for name, module in pairs(Client) do
		module.Client = Client
	end
end

Init()

--- Helper function to determine if this is a solo or multiplayer game
function Client:IsMultiplayer()
	return getWorld():getGameMode() == "Multiplayer"
end

return Client